<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST,GET,PUT,PATCH,DELETE');
header('Content-Type: application/json');
header('Accept: application/json');
header('Access-Control-Allow-Headers: Access-Control-Allow-Origin, Access-Control-Allow-Methods, Content-Type');

include("config.php");

// Only accept POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['res' => 'error', 'message' => 'Only POST allowed']); exit;
}

// Validate action properly (use == or ===, not =)
$action = isset($_POST['action']) ? trim($_POST['action']) : '';
if ($action !== 'payOrder') {
    echo json_encode(['res' => 'error', 'message' => 'Invalid action']); exit;
}

// Razorpay keys (test mode)
$razorpay_mode = 'test';
$razorpay_test_key = 'rzp_test_R9EMlBRnZCCqN2'; // test key
$razorpay_test_secret_key = 'xd4dYyKEArzq1hOpQZZyNP73'; // test secret

if ($razorpay_mode === 'test') {
    $razorpay_key = $razorpay_test_key;
    $authAPIkey = "Basic " . base64_encode($razorpay_test_key . ":" . $razorpay_test_secret_key);
} else {
    // If you enable live mode, set live key variables accordingly
    $razorpay_key = $razorpay_live_key ?? '';
    $authAPIkey = "Basic " . base64_encode(($razorpay_live_key ?? '') . ":" . ($razorpay_live_secret_key ?? ''));
}


$memid=$_POST['mid'];
$amt=sprintf("%.2f",$_POST['total_paise']/100);
$contribution=$_POST['contribution'];
$reg=sprintf("%.2f",$amt-$contribution);
$date = date("d/m/Y");
$time = date("h:i:s A");


// Read and sanitize inputs
$mid = isset($_POST['mid']) ? (int)$_POST['mid'] : 0;
// Accept either 'amt' (rupees, decimal) OR 'total_paise' (integer paise) or 'total_rupees'
$amt_input = isset($_POST['amt']) ? trim($_POST['amt']) : null;
$total_paise_input = isset($_POST['total_paise']) ? trim($_POST['total_paise']) : null;
$total_rupees_input = isset($_POST['total_rupees']) ? trim($_POST['total_rupees']) : null;
$cont = isset($_POST['cont']) ? trim($_POST['cont']) : '0';

// Decide amount (in rupees and paise)
$amount_rupees = 0.00;
$amount_paise = 0;

if ($total_paise_input !== null && is_numeric($total_paise_input)) {
    $amount_paise = intval($total_paise_input);
    $amount_rupees = $amount_paise / 100.0;
} elseif ($total_rupees_input !== null && is_numeric($total_rupees_input)) {
    $amount_rupees = floatval($total_rupees_input);
    $amount_paise = intval(round($amount_rupees * 100));
} elseif ($amt_input !== null && is_numeric($amt_input)) {
    // legacy: 'amt' treated as rupees in original code
    $amount_rupees = floatval($amt_input);
    $amount_paise = intval(round($amount_rupees * 100));
} else {
    echo json_encode(['res' => 'error', 'message' => 'Invalid amount']); exit;
}





// Fetch member details safely
$name = $mail = $phone = '';
if ($mid > 0) {
    $mid_safe = $mid;
    $sql = mysqli_query($db, "SELECT name, email, phone FROM members WHERE id = $mid_safe LIMIT 1");
    if ($sql && mysqli_num_rows($sql) > 0) {
        $row = mysqli_fetch_assoc($sql);
        $name = $row['name'] ?? '';
        $mail = $row['email'] ?? '';
        $phone = $row['phone'] ?? '';
    } else {
        // if no member found, still proceed but with blank contact details
        // Alternatively, return error: uncomment the next two lines to require valid member
        // echo json_encode(['res'=>'error','message'=>'Member not found']); exit;
    }
}

// Generate internal order id (not Razorpay order id)
$order_id = "GCETT" . time();

mysqli_query($db,"insert into transactions(oid,memid,amount,type,date,time,transid,paystat) values('$order_id','$mid','$reg','Registration','$date','$time','','Pending')");
mysqli_query($db,"insert into transactions(oid,memid,amount,type,date,time,transid,paystat) values('$order_id','$mid','$contribution','Contribution','$date','$time','','Pending')");

$note = "Payment of amount Rs. " . number_format($amount_rupees, 2);

// Build payload for Razorpay order creation
$postdata = array(
    "amount" => $amount_paise, // paise (integer)
    "currency" => "INR",
    "receipt" => $note,
    "notes" => array(
        "member_id" => $mid,
        "contribution" => $cont
    )
);

// create Razorpay order via cURL
$curl = curl_init();
curl_setopt_array($curl, array(
    CURLOPT_URL => 'https://api.razorpay.com/v1/orders',
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => '',
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => 'POST',
    CURLOPT_POSTFIELDS => json_encode($postdata),
    CURLOPT_HTTPHEADER => array(
        'Content-Type: application/json',
        'Authorization: ' . $authAPIkey
    ),
));

$response = curl_exec($curl);
$curl_err = curl_error($curl);
$http_status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
curl_close($curl);

if ($curl_err) {
    echo json_encode(['res' => 'error', 'message' => 'Curl error: ' . $curl_err]); exit;
}

$orderRes = json_decode($response);
if (!$orderRes || !isset($orderRes->id) || $http_status < 200 || $http_status >= 300) {
    // return full response for debugging during dev (but avoid leaking secrets)
    echo json_encode(['res' => 'error', 'message' => 'Razorpay order creation failed', 'debug' => $response]); exit;
}

$rpay_order_id = $orderRes->id;

// Build the response userData — note: amount must be in paise for Razorpay options.amount
$dataArr = array(
    'amount' => $amount_paise,               // paise (integer) — front-end expects this
    'description' => "Pay bill of Rs. " . number_format($amount_rupees, 2),
    'rpay_order_id' => $rpay_order_id,
    'mid' => $mid,
    'name' => $name,
    'email' => $mail,
    'mobile' => $phone,
    'amt_rupees' => number_format($amount_rupees, 2),
    'cont' => $cont,
    'date' => $date,
    'time' => $time
);

// Return success JSON
echo json_encode([
    'res' => 'success',
    'order_number' => $order_id,
    'userData' => $dataArr,
    'razorpay_key' => $razorpay_key,
    'mid' => $mid
]);
exit;
?>
