<?php
include("config.php");

if(isset($_COOKIE['loginEmail']))
{
    


$m=date("n");

if($m>=7)
{
    $max=date("Y");
}
else
{
    $y=date("Y");
    $max=$y-1;
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>GCETTB Alumni Association Portal</title>
  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
  <script src="https://code.jquery.com/jquery-3.7.1.js" integrity="sha256-eKhayi8LEQwp4NKxN+CfCh+3qOVUtJn3QNZ0TciWLP4=" crossorigin="anonymous"></script>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css" integrity="sha512-Evv84Mr4kqVGRNSgIGL/F/aIDqQb7xQ2vcrdIwxfjThSH8CSR7PBEakCr51Ck+w+/U6swU2Im1vVX0SVk9ABhg==" crossorigin="anonymous" referrerpolicy="no-referrer" />
  
  <link rel="stylesheet" href="css/style.css">
  <link rel="stylesheet" href="css/register.css">
  <style>
      footer
      {
          margin-top:10%;
      }
      input::-webkit-outer-spin-button,
input::-webkit-inner-spin-button {
  -webkit-appearance: none; /* Optional: Removes any default margin */
}
  </style>
</head>
<body>

  <!-- Header -->
  <?php include("header.php");?>
  
  <!-- Modal Structure -->
  <div class="modal fade" id="infoModal" tabindex="-1" aria-labelledby="infoModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        
        <!-- Modal Header -->
        <div class="modal-header d-flex justify-content-between">
          <h5 class="modal-title" id="infoModalLabel">Our Membership Packages</h5>
         <!-- <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"><i class="fa fa-close"></i></button> -->
        </div>
        
        <!-- Modal Body -->
        <div class="modal-body">
          <label>Here is the list of all the membership packages. </label><br>
          <?php
          $memsql=mysqli_query($db,"select * from category where status='Active' ");
          $sl=0;
          if(mysqli_num_rows($memsql))
          {
              while($mem=mysqli_fetch_assoc($memsql))
              {$sl=$sl+1;
              ?>
              <div class="card mb-3">
                  <div class="card-body bg-light">
                      <div class="row">
                          <div class="col-6">
                              <small><strong><?php echo $mem['catname'];?></strong></small><br>
                              <small><?php echo $mem['description'];?></small><br>
                              <small class="mt-2">Validity: <span class="text-primary"><?php echo $mem['validity']." year";?></span></small> | 
                              <small class="mt-2">EMI: <span class="text-primary"><?php echo $mem['emi'];?></span></small>
                          </div>
                          <div class="col-6 d-flex justify-content-end align-items-end">
                              <h2 class="text-primary"><small>₹</small><?php echo $mem['pricing'];?></h2>
                          </div>
                      </div>
                  </div>
              </div>
              
                  
                  
                  
                  
                  
              <?php
              }
          }
          ?>
        </div>
        
        <!-- Modal Footer -->
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
         <!-- <button type="button" class="btn btn-primary">Save changes</button> -->
        </div>
        
      </div>
    </div>
  </div>

  <!-- Main Section -->
  <main class="container-fluid py-4" style="height: 78%;">
    <h4 class="text-primary text-center mb-4">GCETTB ALUMNI ASSOCIATION PORTAL</h4>
    
    
    <form class="container form-container" action="reg.php" method="POST" enctype="multipart/form-data">

  <!-- Progress Bar -->
  <div class="progress">
    <div class="progress-bar" id="progressBar" style="width: 20%;"></div>
  </div>

  <div class="row g-0">
    <!-- Left Tabs -->
    <div class="col-md-4 bg-light">
      <ul class="nav nav-tabs flex-column" id="formTabs">
        <li class="nav-item">
          <a class="nav-link active" data-bs-target="#personal" data-bs-toggle="tab" href="#">Personal Info</a>
        </li>
        <li class="nav-item">
          <a class="nav-link" data-bs-target="#whoiam" data-bs-toggle="tab" href="#">Relation to CTTB/GCETTB</a>
        </li>
        <li class="nav-item">
          <a class="nav-link" data-bs-target="#professional" data-bs-toggle="tab" href="#">Professional Info</a>
        </li>
        <li class="nav-item">
          <a class="nav-link" data-bs-target="#chapter" data-bs-toggle="tab" href="#">Chapter Selection</a>
        </li>
      <!--  <li class="nav-item">
          <a class="nav-link" data-bs-target="#payment" data-bs-toggle="tab" href="#">Payment Info</a>
        </li> -->
      </ul>
    </div>

    <!-- Right Content -->
    <div class="col-md-8">
      <div class="tab-content">

        <!-- 1️⃣ Personal Info -->
        <div class="tab-pane fade show active" id="personal">
          <div class="card p-4">
            <div class="form-group">
              <small class="text-primary"><strong>Full Name<span class="text-danger">*</span></strong></small>
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text"><i class="fa-solid fa-user"></i></span>
                </div>
                <input type="text" name="name" class="form-control" placeholder="Enter your Full Name" required>
              </div>
            </div>
            <div class="form-group">
              <small class="text-primary"><strong>Email<span class="text-danger">*</span></strong></small>
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text"><i class="fa-solid fa-envelope"></i></span>
                </div>
                <input type="email" name="email" class="form-control" pattern="^[^@]+@[^@]+\.[^@]+$" placeholder="Enter Email" value="<?php echo $_COOKIE['loginEmail'];?>" readonly required>
              </div>
             
            </div>
            <div class="form-group">
              <small class="text-primary"><strong>Password<span class="text-danger">*</span></strong></small>
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text"><i class="fa-solid fa-envelope"></i></span>
                </div>
                <input type="password" name="pass" class="form-control" placeholder="Enter Email" value="<?php echo $_COOKIE['loginPassword'];?>" readonly required>
              </div>
             
            </div>
            <div class="form-group">
              <small class="text-primary"><strong>Phone Number<span class="text-danger">*</span></strong></small>
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text"><i class="fa-solid fa-phone"></i></span>
                </div>
                <input type="tel" name="phone" class="form-control" placeholder="Enter Phone Number with Country Code" pattern="^\+\d{1,4}\d{10}$" required>
              </div>
             
            </div>
            
            <div class="form-group">
              <small class="text-primary"><strong>Whatsapp Number</strong></small>
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text"><i class="fa-brands fa-whatsapp"></i></span>
                </div>
                <input type="number" name="wapp" class="form-control" placeholder="Enter Whatsapp Number">
              </div>
             
            </div>
            
            <div class="form-group">
              <small class="text-primary"><strong>Address<span class="text-danger">*</span></strong></small>
              <div class="input-group mb-3">
                <div class="input-group-prepend">
                  <span class="input-group-text"><i class="fa-solid fa-address-book"></i></span>
                </div>
                <input type="text" name="add1" class="form-control" placeholder="Enter Address Line 1" required>
              </div>
              <div class="input-group mb-3">
                <div class="input-group-prepend">
                  <span class="input-group-text"><i class="fa-solid fa-address-book"></i></span>
                </div>
                <input type="text" name="add2" class="form-control" placeholder="Enter Address Line 2">
              </div>
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text"><i class="fa-solid fa-address-book"></i></span>
                </div>
                <input type="text" name="add3" class="form-control" placeholder="Enter Address Line 3">
              </div>
            </div>
            
            <div class="form-group">
              <small class="text-primary"><strong>ZIP/PIN<span class="text-danger">*</span></strong></small>
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text"><i class="fa-solid fa-address-book"></i></span>
                </div>
                <input type="text" name="pin" class="form-control" placeholder="Enter ZIP/PIN" required>
              </div>
            </div>
            
            <div class="form-group">
              <small class="text-primary"><strong>City<span class="text-danger">*</span></strong></small>
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text"><i class="fa-solid fa-address-book"></i></span>
                </div>
                <input type="text" name="city" class="form-control" placeholder="Enter City" required>
              </div>
            </div>
            
            <div class="form-group">
              <small class="text-primary"><strong>State<span class="text-danger">*</span></strong></small>
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text"><i class="fa-solid fa-address-book"></i></span>
                </div>
                <input type="text" name="state" class="form-control" placeholder="Enter State" required>
              </div>
            </div>
            
            <div class="form-group">
              <small class="text-primary"><strong>Country<span class="text-danger">*</span></strong></small>
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text"><i class="fa-solid fa-ring"></i></span>
                </div>
                <select class="form-control" name="country">
                    <option disabled selected>Select Country</option>
                    <?php
                    $sql=mysqli_query($db,"select * from country");
                    if(mysqli_num_rows($sql))
                    {
                        while($row=mysqli_fetch_assoc($sql))
                        {
                            ?>
                               <option><?php echo $row['country'];?></option>
                            <?php
                        }
                    }
                    ?>

                </select>
                
              </div>
            </div>
            
            <div class="form-group">
              <small class="text-primary"><strong>Date Of Birth<span class="text-danger">*</span></strong></small>
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text"><i class="fa-solid fa-cake-candles"></i></span>
                </div>
                <input type="date" name="dob" class="form-control" max="<?= date('Y-m-d'); ?>" required>
              </div>
            </div>
            
            <div class="form-group">
              <small class="text-primary"><strong>Gender<span class="text-danger">*</span></strong></small>
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text"><i class="fa-solid fa-venus-mars"></i></span>
                </div>
                <select class="form-control" name="gender">
                    <option disabled selected>Select Gender</option>
                    <option>Male</option>
                    <option>Female</option>
                    <option>Prefer not to say</option>
                </select>
                
              </div>
             
            </div>
            
            <div class="form-group">
              <small class="text-primary"><strong>Marital Status<span class="text-danger">*</span></strong></small>
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text"><i class="fa-solid fa-ring"></i></span>
                </div>
                <select class="form-control" name="marital">
                    <option disabled selected>Select Marital Status</option>
                    <option>Single</option>
                    <option>Married</option>
                    <option>Divorced</option>
                    <option>Widowed</option>
                    <option>Separate</option>
                    <option>Cohabiting</option>
                    <option>Registered Partnership</option>
                </select>
                
              </div>
            </div>
            
            <div class="form-group">
              <small class="text-primary"><strong>No of family member(s)</strong></small>
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text"><i class="fa-solid fa-hashtag"></i></span>
                </div>
                <input type="number" class="form-control" name="nofam" placeholder="Enter No of family members">
              </div>
            </div>
            
            
            
            <div class="form-group">
              <small class="text-primary"><strong>Government Issued ID<span class="text-danger">*</span></strong></small>
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text"><i class="fa-solid fa-hashtag"></i></span>
                </div>
                <input type="file" class="form-control" name="govtid" accept="image/*">
              </div>
            </div>
            
          <!--  <button class="btn btn-primary next-tab">Save & Continue</button> -->
          </div>
        </div>

        <!-- 2️⃣ Who I Am -->
        <div class="tab-pane fade" id="whoiam">
          <div class="card p-4">
            
            <div class="form-group">
              <small class="text-primary"><strong>Passout Year<span class="text-danger">*</span></strong></small>
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text"><i class="fa-solid fa-user-graduate"></i></span>
                </div>
                <input type="number" name="passout" id="passout" class="form-control" placeholder="Enter Passout Year " min="1927" max="<?php echo $max;?>" maxlength="4" required>
              </div>
             
            </div>
            
            <div class="form-group">
              <small class="text-primary"><strong>Degree<span class="text-danger">*</span></strong></small>
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text"><i class="fa-solid fa-user-graduate"></i></span>
                </div>
                <select class="form-control" name="degree" id="deg">
                    <option disabled selected>Select Degree</option>
                    <?php
                    $dsql=mysqli_query($db,"select * from degrees");
                    if(mysqli_num_rows($dsql))
                    {
                        while($drow=mysqli_fetch_assoc($dsql))
                        {
                            ?>
                            <option value="<?php echo $drow['id'];?>"><?php echo $drow['degree'];?></option>
                            <?php
                        }
                    }
                    ?>
                    
                   
                    
                </select>
                
              </div>
            </div>
            
            <div class="form-group">
              <small class="text-primary"><strong>Stream<span class="text-danger">*</span></strong></small>
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text"><i class="fa-solid fa-user-graduate"></i></span>
                </div>
                <select class="form-control" name="stream" id="stream">
                    <option disabled selected>Select Stream</option>
                    <?php
                    $stsql=mysqli_query($db,"select * from stream");
                    if(mysqli_num_rows($stsql))
                    {
                        while($strow=mysqli_fetch_assoc($stsql))
                        {
                            ?>
                            <option value="<?php echo $strow['id'];?>"><?php echo $strow['stream'];?></option>
                            <?php
                        }
                    }
                    ?>
                </select>
                
              </div>
            </div>
            
          </div>
        </div>

        <!-- 3️⃣ Professional Info -->
        <div class="tab-pane fade" id="professional">
          <div class="card p-4">
            
            <div class="form-group">
              <small class="text-primary"><strong>Work Status<span class="text-danger">*</span></strong></small>
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text"><i class="fa-solid fa-briefcase"></i></span>
                </div>
                <select class="form-control" name="wstat">
                    <option disabled selected>Select Work Status</option>
                    <option>Not Applicable</option>
                    <option>Freshers</option>
                    <option>Full Time</option>
                    <option>Part Time</option>
                    <option>Retired</option>
                    
                </select>
                
              </div>
             <!-- <small><a href="#" class="text-danger float-right mt-1 mb-2">Forgot Password?</a></small> -->
            </div>
            
            <div class="form-group">
              <small class="text-primary"><strong>Designation</small>
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text"><i class="fa-solid fa-user-tie"></i></span>
                </div>
                <input type="text" name="designation" class="form-control" placeholder="Enter Designation">
              </div>
             
            </div>
            
            <div class="form-group">
              <small class="text-primary"><strong>Current Organisation</small>
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text"><i class="fa-solid fa-building"></i></span>
                </div>
                <input type="text" name="corg" class="form-control" placeholder="Enter Current Organisation">
              </div>
             
            </div>
            
            <div class="form-group">
              <small class="text-primary"><strong>Official Email Address</strong></small>
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text"><i class="fa-solid fa-envelope-open"></i></span>
                </div>
                <input type="text" name="offmail" class="form-control" placeholder="Enter Official Email Address">
              </div>
             
            </div>
            
            <div class="form-group">
              <small class="text-primary"><strong>Country of Current Location<span class="text-danger">*</span></strong></small>
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text"><i class="fa-solid fa-globe"></i></span>
                </div>
                <select class="form-control" name="curcountry">
                    <option disabled selected>Select Country</option>
                    <?php
                    $sql=mysqli_query($db,"select * from country");
                    if(mysqli_num_rows($sql))
                    {
                        while($row=mysqli_fetch_assoc($sql))
                        {
                            ?>
                               <option><?php echo $row['country'];?></option>
                            <?php
                        }
                    }
                    ?>
  
                
                </select>
              </div>
             
            </div>
            
            <div class="form-group">
              <small class="text-primary"><strong>City of Current Location<span class="text-danger">*</span></strong></small>
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text"><i class="fa-solid fa-location-dot"></i></span>
                </div>
                <input type="text" name="curcity" class="form-control" placeholder="Enter City" required>
              </div>
             
            </div>
            
            <div class="form-group">
              <small class="text-primary"><strong>Previous Organisation</strong></small>
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text"><i class="fa-solid fa-building"></i></span>
                </div>
                <input type="text" name="prevorg" class="form-control" placeholder="Enter Previous Organisation">
              </div>
             
            </div>
            
          </div>
        </div>

        <!-- 4️⃣ Chapter Selection -->
        <div class="tab-pane fade" id="chapter">
          <div class="card p-4">
            <div class="form-group">
              <small class="text-primary"><strong>Opting for Chapter<span class="text-danger">*</span></strong></small>
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text"><i class="fa-solid fa-book-open"></i></span>
                </div>
                <select class="form-control" name="chapter">
                    <option disabled selected>Select Chapter</option>
                    <?php
                    $chsql=mysqli_query($db,"select * from chapters");
                    if(mysqli_num_rows($chsql))
                    {
                        while($chrow=mysqli_fetch_assoc($chsql))
                        {
                            ?>
                            <option value="<?php echo $chrow['id'];?>"><?php echo $chrow['chaptername']." - ".$chrow['region'];?></option>
                            <?php
                        }
                    }
                    ?>

                </select>
              </div>
            </div>
            <div class="form-group">
              <small class="text-primary"><strong>Select Membership Category<span class="text-danger">*</span></strong></small>
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text"><i class="fa-solid fa-credit-card"></i></span>
                </div>
                <select class="form-control" name="catid">
                    <option disabled selected>Select Membership Category</option>
                    <?php
                    $mcsql=mysqli_query($db,"select * from category");
                    if(mysqli_num_rows($mcsql))
                    {
                        while($mcrow=mysqli_fetch_assoc($mcsql))
                        {
                            ?>
                            <option value="<?php echo $mcrow['id'];?>"><?php echo $mcrow['catname'];?></option>
                            <?php
                        }
                    }
                    ?>
                    
                </select>
                
                <!-- Button to Open Modal -->
  
              </div>
             <small class="text-primary" data-bs-toggle="modal" data-bs-target="#infoModal" style="cursor:pointer;">Tell me about membership plans</small>
            </div>
            
          </div>
        </div>

        <!-- 5️⃣ Payment Info 
        <div class="tab-pane fade" id="payment">
          <div class="card p-4">
            <h5 class="mb-3">Payment Information</h5>
            <div class="mb-3">
              <small class="form-small">Payment Mode</label>
              <select class="form-control">
                <option>UPI</option>
                <option>Net Banking</option>
                <option>Credit/Debit Card</option>
              </select>
            </div>
            <div class="mb-3">
              <label class="form-label">Transaction ID</label>
              <input type="text" class="form-control" placeholder="Enter transaction ID">
            </div>
            <button class="btn btn-success">Submit Application</button>
          </div>
        </div> -->

      </div>
      
    </div>
    <div class="card mt-4 p-2">
                <label><input type="checkbox" required> I hereby declare that the information provided above is true, complete, and accurate to the best of my knowledge. I understand that any false or misleading information may result in disciplinary action, including termination or disqualification from consideration.</label>
               
            </div>
            
            
            <center>
                <button class="btn btn-primary m-3 float-right" style="width:100px;">Register</button>
            </center>
  </div>
</form>

  </main>

  <!-- Footer -->
  <?php include("footer.php");?>

</body>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
    $(document).ready(function(){
        
        let m=["JAN","FEB","MAR","APR","MAY","JUN","JUL","AUG","SEP","OCT","NOV","DEC"];
        
        let dt=new Date();
        
        let date=dt.getDate();
        let mon=dt.getMonth();
        let yr=dt.getFullYear();
        
        $("#day").text(date);
        $("#mon").text(m[mon]);
        $("#yr").text(yr);
        
        $("#mail").change(function(){
        /*let deg=$("#deg").val();
        
        var xmlhttp = new XMLHttpRequest();
    xmlhttp.onreadystatechange = function() {
      if (this.readyState == 4 && this.status == 200) {
          
          $("#stream").val(this.responseText);
        
      }
    };
    xmlhttp.open("GET", "getstream.php?deg=" + deg, true);
    xmlhttp.send();*/
    
    alert("ss");
    })
        
        
        
    })
</script>
<script>
$(document).ready(function(){
    // Get today's date in YYYY-MM-DD format
    var today = new Date().toISOString().split('T')[0];
    
    // Set max attribute to today → prevents future dates
    $('#myDate').attr('max', today);
    
    $("#passout").change(function(){
        let pout=$("#passout").val();
        
        var xmlhttp = new XMLHttpRequest();
    xmlhttp.onreadystatechange = function() {
      if (this.readyState == 4 && this.status == 200) {
          
          $("#deg").val(this.responseText);
        
      }
    };
    xmlhttp.open("GET", "getdegree.php?yr=" + pout, true);
    xmlhttp.send();
    })
    
    $("#deg").change(function(){
        let deg=$("#deg").val();
        
        var xmlhttp = new XMLHttpRequest();
    xmlhttp.onreadystatechange = function() {
      if (this.readyState == 4 && this.status == 200) {
          
          $("#stream").val(this.responseText);
        
      }
    };
    
    
});
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<script>
$(document).ready(function() {
  const tabs = $('#formTabs .nav-link');
  const progressBar = $('#progressBar');
  const totalTabs = tabs.length;

  // Handle next button click
  $('.next-tab').on('click', function() {
    const activeTab = $('#formTabs .nav-link.active');
    const nextTab = activeTab.parent().next().find('.nav-link');

    if (nextTab.length) {
      nextTab.tab('show');
      updateProgress(nextTab.index());
    }
  });

  // Update progress on tab change
  tabs.on('shown.bs.tab', function(e) {
    updateProgress($(e.target).parent().index());
  });

  function updateProgress(index) {
    const progress = ((index + 1) / totalTabs) * 100;
    progressBar.css('width', progress + '%');
  }
});
</script>

</html>
<?php
}
else{
    header("Location:index.php");
}