<?php
include("config.php");

// sanitize memid
$memid = isset($_GET['memid']) ? (int)$_GET['memid'] : 0;

// default safe values
$memcat = 0;
$price = 0;
$regamt = 0;
$gst = 'Disabled';
$emi = 0;

if($memid > 0){
    $catsql = mysqli_query($db, "SELECT memcat FROM members WHERE id = $memid LIMIT 1");
    if($catsql && mysqli_num_rows($catsql) > 0){
        list($memcat) = mysqli_fetch_row($catsql);
        $memcat = (int)$memcat;
    }
    if($memcat > 0){
        $psql = mysqli_query($db, "SELECT pricing, regamt, gst, emi FROM category WHERE id = $memcat LIMIT 1");
        if($psql && mysqli_num_rows($psql) > 0){
            list($price, $regamt, $gst, $emi) = mysqli_fetch_row($psql);
            $price = floatval($price);
            $regamt = floatval($regamt);
            $gst = trim($gst);
            $emi = floatval($emi);
        }
    }
}

// calculate gst (assuming "Enabled" is the flag)
if(strcasecmp($gst, "Enabled") === 0){
    $gstval = round(($price + $regamt) * 0.18, 2);
} else {
    $gstval = 0.00;
}

// total in rupees
$total = round($price + $regamt + $gstval, 2);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Payment Page - GCETT</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" />
</head>
<body class="bg-light">

<div class="container mt-5">
  <div class="card shadow-lg">
    <div class="card-header bg-primary text-white text-center">
      <label>Registration Payment</label>
    </div>
    <div class="card-body">
      <form id="paymentForm" onsubmit="return false;">
        <input type="hidden" id="mid" value="<?php echo $memid;?>">
        <div class="mb-3">
          <label for="regFee" class="form-label">Registration Fee</label>
          <input type="text" class="form-control" id="regFee" value="<?php echo number_format($regamt,2,'.','');?>" readonly />
        </div>

        <div class="mb-3">
          <label for="memAmt" class="form-label">Membership Amount</label>
          <input type="text" class="form-control" id="memAmt" value="<?php echo number_format($price,2,'.','');?>" readonly />
        </div>

        <div class="mb-3">
          <label for="gstCharge" class="form-label">GST (18%)</label>
          <input type="text" class="form-control" id="gstCharge" value="<?php echo number_format($gstval,2,'.','');?>" readonly />
        </div>

        <div class="mb-3">
          <label for="userContribution" class="form-label">Your Additional Contribution (Optional)</label>
          <input type="number" step="0.01" class="form-control" id="userContribution" placeholder="Enter any additional contribution" min="0" />
        </div>

        <div class="mb-3">
          <label for="totalAmount" class="form-label">Total Amount (₹)</label>
          <input type="text" class="form-control" id="totalAmount" value="<?php echo number_format($total,2,'.','');?>" readonly />
        </div>

        <div class="text-center mb-2">
          <button type="button" id="PayNow" class="btn btn-success mt-3">Proceed to Payment</button>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- jQuery (required) -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://checkout.razorpay.com/v1/checkout.js"></script>

<script>
  // initial numeric values from server (JS numbers)
  const regFee = parseFloat(<?php echo json_encode(number_format($regamt,2,'.','')); ?>);
  const price = parseFloat(<?php echo json_encode(number_format($price,2,'.','')); ?>);
  const gst = parseFloat(<?php echo json_encode(number_format($gstval,2,'.','')); ?>);

  $(function(){
    const $userInput = $('#userContribution');
    const $totalAmount = $('#totalAmount');

    function recalcTotal(){
      const contribution = parseFloat($userInput.val()) || 0;
      const total = +(regFee + price + gst + contribution).toFixed(2);
      $totalAmount.val(total.toFixed(2));
      return total;
    }

    $userInput.on('input', recalcTotal);

    $('#PayNow').on('click', function(e){
      e.preventDefault();

      const mid = $('#mid').val();
      const contribution = parseFloat($('#userContribution').val()) || 0;
      // total rupees
      const totalRupees = recalcTotal();

      // Razorpay needs amount in paise (integer)
      const amountPaise = Math.round(totalRupees * 100);

      // Optionally validate min amount
      if(amountPaise <= 0){
        alert('Invalid amount to pay.');
        return;
      }

      // Prepare payload to server
      const formData = {
        mid: mid,
        // sending rupees and paise both can be helpful depending on server expectation
        total_rupees: totalRupees.toFixed(2),
        total_paise: amountPaise,
        contribution: contribution.toFixed(2),
        paymentOption: 'netbanking',
        action: 'payOrder'
      };

      $.ajax({
        type: 'POST',
        url: 'submitpayment.php',
        data: formData,
        dataType: 'json'
      }).done(function(data){
        // expected server response format (example)
        // { res: 'success', order_number: 'ORD123', razorpay_key: 'rzp_live_xxx', userData: { amount: 10000, rpay_order_id: 'order_ABC', description: '...', name:'..', email:'..', mobile:'..' } }
        if(!data || data.res !== 'success'){
          alert('Server error: ' + (data && data.message ? data.message : 'unknown'));
          return;
        }

        const orderID = data.order_number;
        const rpayKey = data.razorpay_key;
        const userData = data.userData || {};

        // Basic sanity check
        if(!rpayKey || !userData.amount || !userData.rpay_order_id){
          alert('Invalid payment data returned from server.');
          return;
        }

        const options = {
          "key": rpayKey,
          "amount": userData.amount, // in paise (server should give paise)
          "currency": "INR",
          "name": "Alumni Association of GCETTB",
          "description": userData.description || '',
          "image": "https://projects.techacore.in/gcett/img/logo.png",
          "order_id": userData.rpay_order_id,
          "handler": function (response){
            // successful payment
            // server-side verification is required too
            window.location.replace("payment-success.php?oid=" + encodeURIComponent(orderID) + "&rp_payment_id=" + encodeURIComponent(response.razorpay_payment_id) + "&rp_signature=" + encodeURIComponent(response.razorpay_signature));
          },
          "modal": {
            "ondismiss": function(){
              // user closed the modal without completing payment
              window.location.replace("payment-failed.php?oid=" + encodeURIComponent(orderID) + "&reason=dismissed");
            }
          },
          "prefill": {
              "name": userData.name || '',
              "email": userData.email || '',
              "contact": userData.mobile || ''
          },
          "notes": {
              "address": "Alumni Association of GCETTB"
          },
          "theme": {
              "color": "#365b6d"
          }
        };

        var rzp1 = new Razorpay(options);
        rzp1.on('payment.failed', function (response){
          const reason = (response && response.error && response.error.description) ? response.error.description : 'failed';
          const paymentid = (response && response.error && response.error.metadata && response.error.metadata.payment_id) ? response.error.metadata.payment_id : '';
          window.location.replace("payment-failed.php?oid=" + encodeURIComponent(orderID) + "&reason=" + encodeURIComponent(reason) + "&paymentid=" + encodeURIComponent(paymentid));
        });

        rzp1.open();
      }).fail(function(xhr, status, err){
        alert('AJAX error: ' + err);
      });

    });
  });
</script>

</body>
</html>
